/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.blocks.tileentities;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.tools.MATags;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.items.ItemInit;
import com.mna.items.artifice.charms.ContingencyCharm;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.crafting.SpellRecipe;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.sosly.arcaneadditions.blocks.TileEntityRegistry;

public class ScribesBenchTile
extends WizardLabTile {
    public static final int SLOT_INK = 0;
    public static final int SLOT_LAPIS = 1;
    public static final int SLOT_SPELL = 2;
    public static final int SLOT_VELLUM = 3;
    public static final int INVENTORY_SIZE = 4;
    private static final int LAPIS_REQUIRED_PER_TIER = 10;
    private static final int LAPIS_REQUIRED_PER_TIER_RECHARGE = 2;
    private static final int LAPIS_REQUIRED_PER_TIER_GLYPH = 1;
    private static final int INK_REQUIRED_PER_TIER = 1;
    private float ticksRequired = 100.0f;
    private SpellRecipe copyRecipe;

    public ScribesBenchTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistry.SCRIBES_BENCH.get(), pos, state, 4);
    }

    public boolean canActivate(Player player) {
        ItemStack vellumItem = this.m_8020_(3);
        ItemStack spellItem = this.m_8020_(2);
        if (spellItem.m_41619_() || !(spellItem.m_41720_() instanceof ICanContainSpell)) {
            return false;
        }
        ISpellDefinition spell = ((ICanContainSpell)spellItem.m_41720_()).getSpell(spellItem, player);
        return this.hasStack(3) && this.hasStack(0) && this.m_8020_(0).m_41773_() + this.getInkRequired() <= this.m_8020_(0).m_41776_() && this.hasStack(1) && this.m_8020_(1).m_41613_() >= this.getLapisRequired(player) && this.hasStack(3) && vellumItem.m_41720_() instanceof ICanContainSpell && ((ICanContainSpell)vellumItem.m_41720_()).canAcceptSpell(vellumItem, spell);
    }

    protected boolean canContinue() {
        ItemStack vellumItem = this.m_8020_(3);
        ItemStack spellItem = this.m_8020_(2);
        if (spellItem.m_41619_()) {
            return false;
        }
        ISpellDefinition spell = ((ICanContainSpell)spellItem.m_41720_()).getSpell(spellItem, this.getCrafter());
        return this.copyRecipe != null && this.hasStack(3) && this.hasStack(2) && vellumItem.m_41720_() instanceof ICanContainSpell && ((ICanContainSpell)vellumItem.m_41720_()).canAcceptSpell(vellumItem, spell);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        if (index != 3) {
            return true;
        }
        return direction == Direction.UP || direction == Direction.DOWN;
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        ItemStack existing = this.m_8020_(index);
        switch (index) {
            case 0: {
                return stack.m_41720_() == ItemInit.ARCANIST_INK.get() && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
            case 1: {
                return stack.m_41720_() == Items.f_42534_ && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
            default: {
                return false;
            }
            case 3: 
        }
        return stack.m_41720_() instanceof ICanContainSpell && existing.m_41619_();
    }

    public float getPctComplete() {
        return (float)this.getActiveTicks() / this.ticksRequired;
    }

    protected boolean canActiveTick() {
        if (this.copyRecipe == null || !this.copyRecipe.isValid()) {
            if (!this.m_58904_().m_5776_()) {
                this.setInactive();
            }
            return false;
        }
        return true;
    }

    public int getInkRequired() {
        return this.copyRecipe != null && this.hasStack(3) ? this.copyRecipe.getTier(this.f_58857_) : 0;
    }

    public int getLapisRequired(@Nullable Player player) {
        if (this.copyRecipe != null && this.hasStack(3)) {
            ISpellDefinition spell;
            ItemStack inputStack = this.m_8020_(3);
            if (inputStack.m_41720_() instanceof ContingencyCharm && this.copyRecipe.isSame(spell = ((ICanContainSpell)inputStack.m_41720_()).getSpell(inputStack, player), false, true, true)) {
                return this.copyRecipe.getTier(this.f_58857_) * 2;
            }
            return MATags.isItemIn((Item)inputStack.m_41720_(), (ResourceLocation)MATags.Items.STONE_RUNES) ? this.copyRecipe.getTier(this.f_58857_) * 1 : this.copyRecipe.getTier(this.f_58857_) * 10;
        }
        return 0;
    }

    protected CompoundTag getMeta() {
        CompoundTag tag = new CompoundTag();
        if (this.copyRecipe != null) {
            this.copyRecipe.writeToNBT(tag);
        }
        return tag;
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 3};
    }

    public int getXPCost(Player crafter) {
        return 20;
    }

    protected void loadMeta(CompoundTag tag) {
        this.copyRecipe = SpellRecipe.fromNBT((CompoundTag)tag);
    }

    protected void onComplete() {
        ItemStack output = this.m_8020_(3).m_41777_();
        if (!output.m_41619_()) {
            Player crafter;
            output = ((ICanContainSpell)output.m_41720_()).setSpell(output, (ISpellDefinition)this.copyRecipe);
            ((ICanContainSpell)output.m_41720_()).setTranscribedSpell(output);
            if (this.m_8020_(2).m_41788_()) {
                output.m_41714_(this.m_8020_(2).m_41786_());
            }
            this.m_6836_(3, output);
            if (this.getCrafter() != null && !this.m_58904_().m_5776_() && (crafter = this.getCrafter()) != null) {
                MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(crafter, ProgressionEventIDs.TRANSCRIBE_SPELL));
                if (crafter instanceof ServerPlayer) {
                    CustomAdvancementTriggers.TRANSCRIBE_SPELL.trigger((ServerPlayer)crafter, (ISpellDefinition)this.copyRecipe, output);
                }
            }
            if (!this.m_58904_().m_5776_()) {
                this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Event.Eldrin.DRAW_IN_ITEM, SoundSource.BLOCKS, 1.0f, (float)(0.95 + Math.random() * (double)0.1f));
            }
        }
    }

    protected void onCraftStart(Player crafter) {
        Item item;
        ItemStack book = this.m_8020_(2);
        if (!book.m_41619_() && (item = book.m_41720_()) instanceof ItemSpell) {
            ItemSpell spell = (ItemSpell)item;
            ItemStack input = this.m_8020_(3);
            if (!input.m_41619_() && input.m_41720_() instanceof ICanContainSpell) {
                ItemStack lapis = this.m_8020_(1);
                lapis.m_41774_(this.getLapisRequired(crafter));
                ItemStack ink = this.m_8020_(0);
                if (!this.m_58904_().m_5776_()) {
                    ink.m_220157_(this.getInkRequired(), this.f_58857_.f_46441_, (ServerPlayer)crafter);
                    if (ink.m_41773_() >= ink.m_41776_()) {
                        this.m_6836_(0, ItemStack.f_41583_);
                    }
                }
                if (!this.m_58904_().m_5776_()) {
                    CompoundTag spellTag = spell.getSpellCompound(book, crafter);
                    this.copyRecipe = SpellRecipe.fromNBT((CompoundTag)spellTag);
                    if (!this.copyRecipe.isValid()) {
                        this.setInactive();
                    }
                }
            } else {
                this.setInactive();
            }
        } else {
            this.setInactive();
        }
    }

    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1, 2, 3);
    }
}

