/*
 * Decompiled with CFR 0.152.
 */
package net.vastless.create_magics.spells.component;

import com.mna.api.affinity.Affinity;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.vastless.create_magics.IManaStorage;
import net.vastless.create_magics.Utils.Utils;

public class ManaRouterComponent
extends SpellEffect {
    public ManaRouterComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    public ComponentApplicationResult ApplyEffect(SpellSource spellSource, SpellTarget spellTarget, IModifiedSpellPart<SpellEffect> iModifiedSpellPart, SpellContext spellContext) {
        ComponentApplicationResult result = ComponentApplicationResult.FAIL;
        if (spellTarget.isBlock()) {
            BlockPos blockPos = spellTarget.getBlock();
            ServerLevel world = spellContext.getServerLevel();
            if (this.canReceivePower(spellContext.getLevel(), blockPos)) {
                this.applyManaPower(spellSource, (Level)world, blockPos);
                result = ComponentApplicationResult.SUCCESS;
            }
        }
        return result;
    }

    private boolean canReceivePower(Level world, BlockPos pos) {
        IManaStorage storage = Utils.HasManaStorage(world, pos);
        return storage != null && storage.isConsumer() && storage.getMana() + 5.0f <= storage.getMaxMana();
    }

    private void applyManaPower(SpellSource spellSource, Level world, BlockPos blockPos) {
        IManaStorage storage = Utils.HasManaStorage(world, blockPos);
        if (storage != null) {
            storage.addMana(5.0f);
        }
    }

    public Affinity getAffinity() {
        return Affinity.UNKNOWN;
    }

    public float initialComplexity() {
        return 1.0f;
    }

    public int requiredXPForRote() {
        return 500;
    }
}

