/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.niofs.union.UnionFileSystem;
import java.lang.reflect.Field;
import java.nio.file.FileSystem;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import net.minecraftforge.forgespi.locating.IModFile;
import org.sinytra.connector.locator.PackageTracker;
import org.slf4j.Logger;

public final class ForgeModPackageFilter {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void filterPackages(Iterable<IModFile> fmlMods) {
        Set<String> existingPackages = ForgeModPackageFilter.class.getModule().getPackages();
        for (IModFile modFile : fmlMods) {
            ForgeModPackageFilter.filterModFile(modFile, existingPackages);
        }
    }

    private static void filterModFile(IModFile modFile, Set<String> existingPackages) {
        SecureJar jar = modFile.getSecureJar();
        Set packages = jar.getPackages();
        Sets.SetView common = Sets.intersection((Set)packages, existingPackages);
        if (!common.isEmpty() && jar instanceof Jar) {
            Jar jarImpl = (Jar)jar;
            LOGGER.debug("Filtering {} packages from mod file {}", (Object)common.size(), (Object)jar.getPrimaryPath().getFileName());
            PackageTracker filter = new PackageTracker((Set<String>)common);
            FileSystem jarFS = jarImpl.getRootPath().getFileSystem();
            if (jarFS instanceof UnionFileSystem) {
                UnionFileSystem ufs = (UnionFileSystem)jarFS;
                ForgeModPackageFilter.injectUFSFilter(ufs, filter);
                ForgeModPackageFilter.forceRecomputeJarPackages(jarImpl);
            }
        }
    }

    private static void injectUFSFilter(UnionFileSystem ufs, BiPredicate<String, String> filter) {
        BiPredicate existing = ufs.getFilesystemFilter();
        BiPredicate<String, String> merged = existing != null ? existing.and(filter) : filter;
        Field pathFilterField = (Field)LamdbaExceptionUtils.uncheck(() -> UnionFileSystem.class.getDeclaredField("pathFilter"));
        UnsafeHacks.setField((Field)pathFilterField, (Object)ufs, merged);
    }

    private static void forceRecomputeJarPackages(Jar jar) {
        Field packagesField = (Field)LamdbaExceptionUtils.uncheck(() -> Jar.class.getDeclaredField("packages"));
        UnsafeHacks.setField((Field)packagesField, (Object)jar, null);
    }
}

