/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client.model;

import com.boyonk.repoheads.client.RepoHeadsClient;
import com.boyonk.repoheads.client.dummy.RepoPlayerEntityRenderState;
import com.boyonk.repoheads.client.mixin.LivingEntityRendererAccessor;
import com.boyonk.repoheads.client.mixin.PlayerEntityRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RepoHeadModel {
    private static final Vector3f TEMP_VECTOR = new Vector3f();
    private static final int TEXTURE_WIDTH = 64;
    private static final int TEXTURE_HEIGHT = 16;
    private static final int SIZE = 8;
    private static final int HALF_SIZE = 4;
    private final ModelPart.Polygon[] topQuads;
    private final ModelPart.Polygon[] bottomQuads;
    private final ModelPart.Polygon[] leftEyeQuads;
    private final ModelPart.Polygon[] rightEyeQuads;

    private RepoHeadModel(ModelPart.Polygon[] topQuads, ModelPart.Polygon[] bottomQuads, ModelPart.Polygon[] leftEyeQuads, ModelPart.Polygon[] rightEyeQuads) {
        this.topQuads = topQuads;
        this.bottomQuads = bottomQuads;
        this.leftEyeQuads = leftEyeQuads;
        this.rightEyeQuads = rightEyeQuads;
    }

    public static RepoHeadModel create(float mouthHeight) {
        ModelPart.Polygon[] bottomQuads = new ModelPart.Polygon[11];
        RepoHeadModel.createQuads(-4.0f, -mouthHeight, -4.0f, 0.0f, 0.0f, mouthHeight, true, false, bottomQuads, 0);
        RepoHeadModel.createQuads(-4.0f, -mouthHeight, -4.0f, 32.0f, 0.0f, mouthHeight, true, true, bottomQuads, 6);
        ModelPart.Polygon[] topQuads = new ModelPart.Polygon[11];
        RepoHeadModel.createQuads(-4.0f, -8.0f, -8.0f, 0.0f, 0.0f, 8.0f - mouthHeight, false, false, topQuads, 0);
        RepoHeadModel.createQuads(-4.0f, -8.0f, -8.0f, 32.0f, 0.0f, 8.0f - mouthHeight, false, true, topQuads, 6);
        ModelPart.Polygon[] leftEyeQuads = new ModelPart.Polygon[]{RepoHeadModel.createEyeQuad(-4.0f, -8.0f, -8.0f, true, false), RepoHeadModel.createEyeQuad(-4.0f, -8.0f, -8.0f, true, true)};
        ModelPart.Polygon[] rightEyeQuads = new ModelPart.Polygon[]{RepoHeadModel.createEyeQuad(-4.0f, -8.0f, -8.0f, false, false), RepoHeadModel.createEyeQuad(-4.0f, -8.0f, -8.0f, false, true)};
        return new RepoHeadModel(topQuads, bottomQuads, leftEyeQuads, rightEyeQuads);
    }

    public static ModelPart.Polygon[] createQuads(float x, float y, float z, float u, float v, float height, boolean bottom, boolean hat, ModelPart.Polygon[] quads, int index) {
        float sizeX = 8.0f;
        float sizeY = 8.0f;
        float sizeZ = 8.0f;
        float minX = x;
        float minY = y;
        float minZ = z;
        float maxX = x + sizeX;
        float maxY = y + height;
        float maxZ = z + sizeZ;
        if (hat) {
            minX -= 0.5f;
            minZ -= 0.5f;
            maxX += 0.5f;
            maxZ += 0.5f;
            if (bottom) {
                maxY += 0.5f;
                minY -= (height - 4.0f) * 0.0625f;
            } else {
                maxY += (height - 4.0f) * 0.0625f;
                minY -= 0.5f;
            }
        }
        ModelPart.Vertex vertex1 = new ModelPart.Vertex(minX, minY, minZ, 0.0f, 0.0f);
        ModelPart.Vertex vertex2 = new ModelPart.Vertex(maxX, minY, minZ, 0.0f, 8.0f);
        ModelPart.Vertex vertex3 = new ModelPart.Vertex(maxX, maxY, minZ, 8.0f, 8.0f);
        ModelPart.Vertex vertex4 = new ModelPart.Vertex(minX, maxY, minZ, 8.0f, 0.0f);
        ModelPart.Vertex vertex5 = new ModelPart.Vertex(minX, minY, maxZ, 0.0f, 0.0f);
        ModelPart.Vertex vertex6 = new ModelPart.Vertex(maxX, minY, maxZ, 0.0f, 8.0f);
        ModelPart.Vertex vertex7 = new ModelPart.Vertex(maxX, maxY, maxZ, 8.0f, 8.0f);
        ModelPart.Vertex vertex8 = new ModelPart.Vertex(minX, maxY, maxZ, 8.0f, 0.0f);
        float k = u + sizeZ;
        float l = u + sizeZ + sizeX;
        float m = u + sizeZ + sizeX + sizeX;
        float n = u + sizeZ + sizeX + sizeZ;
        float o = u + sizeZ + sizeX + sizeZ + sizeX;
        float q = v + sizeZ;
        float r = v + sizeZ + sizeY;
        if (!hat || !bottom) {
            quads[index++] = new ModelPart.Polygon(new ModelPart.Vertex[]{vertex6, vertex5, vertex1, vertex2}, bottom ? l : k, v, bottom ? m : l, q, 64.0f, 16.0f, false, Direction.DOWN);
        }
        if (!hat || bottom) {
            quads[index++] = new ModelPart.Polygon(new ModelPart.Vertex[]{vertex3, vertex4, vertex8, vertex7}, l, q, m, v, 64.0f, 16.0f, false, Direction.UP);
        }
        quads[index++] = new ModelPart.Polygon(new ModelPart.Vertex[]{vertex1, vertex5, vertex8, vertex4}, u, bottom ? r - height : q, k, bottom ? r : q + height, 64.0f, 16.0f, false, Direction.WEST);
        quads[index++] = new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex1, vertex4, vertex3}, k, bottom ? r - height : q, l, bottom ? r : q + height, 64.0f, 16.0f, false, Direction.NORTH);
        quads[index++] = new ModelPart.Polygon(new ModelPart.Vertex[]{vertex6, vertex2, vertex3, vertex7}, l, bottom ? r - height : q, n, bottom ? r : q + height, 64.0f, 16.0f, false, Direction.EAST);
        quads[index] = new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, n, bottom ? r - height : q, o, bottom ? r : q + height, 64.0f, 16.0f, false, Direction.SOUTH);
        return quads;
    }

    public static ModelPart.Polygon createEyeQuad(float x, float y, float z, boolean left, boolean hat) {
        float minX = x;
        float minY = y;
        float minZ = z;
        float maxX = x + 4.0f;
        float maxY = y + 8.0f;
        if (!left) {
            minX += 4.0f;
            maxX += 4.0f;
        }
        if (hat) {
            if (left) {
                minX -= 0.5f;
            } else {
                maxX += 0.5f;
            }
            minZ -= 0.5f;
            maxY += 0.25f;
            minY -= 0.5f;
        }
        ModelPart.Vertex vertex1 = new ModelPart.Vertex(minX, minY, minZ, 0.0f, 0.0f);
        ModelPart.Vertex vertex2 = new ModelPart.Vertex(maxX, minY, minZ, 0.0f, 8.0f);
        ModelPart.Vertex vertex3 = new ModelPart.Vertex(maxX, maxY, minZ, 8.0f, 8.0f);
        ModelPart.Vertex vertex4 = new ModelPart.Vertex(minX, maxY, minZ, 8.0f, 0.0f);
        return new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex1, vertex4, vertex3}, (float)((hat ? 32 : 0) + (left ? 0 : 4)), 0.0f, (float)((hat ? 40 : 8) + (left ? -4 : 0)), 8.0f, 64.0f, 16.0f, false, Direction.NORTH);
    }

    private static void renderQuads(ModelPart.Polygon[] quads, PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        for (ModelPart.Polygon quad : quads) {
            ModelPart.Vertex[] vertices = quad.f_104359_;
            Vector3f normal = entry.m_252943_().transform((Vector3fc)quad.f_104360_, TEMP_VECTOR).normalize();
            float normalX = normal.x();
            float normalY = normal.y();
            float normalZ = normal.z();
            for (ModelPart.Vertex vertex : vertices) {
                Vector3f vertexPos = vertex.f_104371_;
                float u = vertex.f_104372_;
                float v = vertex.f_104373_;
                float x = vertexPos.x() / 16.0f;
                float y = vertexPos.y() / 16.0f;
                float z = vertexPos.z() / 16.0f;
                Vector3f pos = matrix4f.transformPosition(x, y, z, TEMP_VECTOR);
                vertexConsumer.m_5954_(pos.x(), pos.y(), pos.z(), (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f, u, v, overlay, light, normalX, normalY, normalZ);
            }
        }
    }

    private static void renderEye(PositionedDirection eyePositionedDirection, RepoPlayerEntityRenderState.Eye eye, ModelPart.Polygon[] quads, PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        if (!eye.visible) {
            return;
        }
        Vector3f pos = eyePositionedDirection.position.m_252839_();
        Vector3f looking = eyePositionedDirection.looking.m_252839_();
        Vector3f direction = eye.target == null ? looking : new Vector3f((float)eye.target.f_82479_, (float)eye.target.f_82480_, (float)eye.target.f_82481_).sub((Vector3fc)pos).normalize();
        float yawFrom = (float)Math.atan2(looking.z, looking.x);
        float yawTo = (float)Math.atan2(direction.z, direction.x);
        float yaw = yawTo - yawFrom;
        float pitchFrom = (float)Math.atan2(looking.y, Math.sqrt(looking.x * looking.x + looking.z * looking.z));
        float pitchTo = (float)Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z));
        float pitch = pitchTo - pitchFrom;
        yaw *= 57.295776f;
        pitch *= 57.295776f;
        yaw = Mth.m_14177_((float)yaw);
        pitch = Mth.m_14177_((float)pitch);
        if (yaw < -90.0f) {
            yaw = -90.0f - (yaw + 90.0f);
        }
        if (yaw > 90.0f) {
            yaw = 90.0f - (yaw - 90.0f);
        }
        yaw *= -1.0f;
        if (pitch < -90.0f) {
            pitch = -90.0f - (pitch + 90.0f);
        }
        if (pitch > 90.0f) {
            pitch = 90.0f - (pitch - 90.0f);
        }
        pitch *= -1.0f;
        float x = yaw < 0.0f ? Mth.m_14179_((float)(yaw + 1.0f), (float)eye.minX, (float)0.0f) : Mth.m_14179_((float)(yaw /= 90.0f), (float)0.0f, (float)eye.maxX);
        float y = pitch < 0.0f ? Mth.m_14179_((float)(pitch + 1.0f), (float)eye.minY, (float)0.0f) : Mth.m_14179_((float)(pitch /= 90.0f), (float)0.0f, (float)eye.maxY);
        Vector2fc result = eye.eyeRenderUpdater.update(x, y);
        matrices.m_85836_();
        matrices.m_252880_((result.x() + eye.offsetX) * 0.0625f, (result.y() + eye.offsetY) * 0.0625f, 0.0f);
        RepoHeadModel.renderQuads(quads, matrices, vertexConsumer, light, overlay, color);
        matrices.m_85849_();
    }

    public void render(PlayerModel model, Player entity, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, int color, boolean outlineOnly) {
        boolean render = true;
        ModelPart head = model.f_102808_;
        ModelPart hat = model.f_102809_;
        ModelPart mouth = head.m_171324_("mouth");
        mouth.f_233556_ = render;
        hat.f_233556_ = render;
        if (!render) {
            return;
        }
        matrices.m_85836_();
        ResourceLocation texture = ((RepoPlayerEntityRenderState)entity).headTexture();
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(outlineOnly ? RenderType.m_110491_((ResourceLocation)texture) : RenderType.m_110473_((ResourceLocation)texture));
        head.m_104299_(matrices);
        RepoHeadModel.renderQuads(this.bottomQuads, matrices, vertexConsumer, light, overlay, color);
        matrices.m_85836_();
        mouth.m_104299_(matrices);
        RepoHeadModel.renderQuads(this.topQuads, matrices, vertexConsumer, light, overlay, color);
        if (!outlineOnly) {
            vertexConsumer = vertexConsumers.m_6299_(RepoHeadsClient.ENTITY_TRANSLUCENT_OFFSET.apply(texture, true));
            RepoPlayerEntityRenderState.Eye leftEye = ((RepoPlayerEntityRenderState)entity).leftEye();
            RepoPlayerEntityRenderState.Eye rightEye = ((RepoPlayerEntityRenderState)entity).rightEye();
            RepoHeadModel.renderEye(this.getHeadPositionedDirection(model, entity, new Vector3f((leftEye.centerX - 4.0f) * 0.0625f, -(8.0f - leftEye.centerY) * 0.0625f, 0.5f), new Vector3f(0.0f, 0.0f, 1.0f)), leftEye, this.leftEyeQuads, matrices, vertexConsumer, light, overlay, color);
            RepoHeadModel.renderEye(this.getHeadPositionedDirection(model, entity, new Vector3f((rightEye.centerX - 4.0f) * 0.0625f, -(8.0f - rightEye.centerY) * 0.0625f, 0.5f), new Vector3f(0.0f, 0.0f, 1.0f)), rightEye, this.rightEyeQuads, matrices, vertexConsumer, light, overlay, color);
        }
        matrices.m_85849_();
        matrices.m_85849_();
    }

    public PositionedDirection getHeadPositionedDirection(PlayerModel model, Player entity, Vector3f relativePosition, Vector3f relativeDirection) {
        Direction direction;
        ModelPart head = model.f_102808_;
        ModelPart mouth = head.m_171324_("mouth");
        RepoPlayerEntityRenderState renderState = (RepoPlayerEntityRenderState)entity;
        PlayerEntityRendererAccessor playerRenderer = (PlayerEntityRendererAccessor)renderState.renderer();
        AbstractClientPlayer playerEntity = renderState.playerEntity();
        float tickDelta = renderState.tickDelta();
        PoseStack stack = new PoseStack();
        if (playerEntity.m_217003_(Pose.SLEEPING) && (direction = playerEntity.m_21259_()) != null) {
            float n = playerEntity.m_20236_(Pose.STANDING) - 0.1f;
            stack.m_252880_((float)(-direction.m_122429_()) * n, 0.0f, (float)(-direction.m_122431_()) * n);
        }
        playerRenderer.callSetupTransforms(playerEntity, stack, ((LivingEntityRendererAccessor)renderState.renderer()).callGetAnimationProgress(playerEntity, tickDelta), Mth.m_14189_((float)tickDelta, (float)playerEntity.f_20884_, (float)playerEntity.f_20883_), tickDelta);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        playerRenderer.callScale(playerEntity, stack, tickDelta);
        stack.m_252880_(0.0f, -1.501f, 0.0f);
        head.m_104299_(stack);
        mouth.m_104299_(stack);
        Vector3f originLocation = stack.m_85850_().m_252922_().transformPosition(new Vector3f(0.0f, 0.0f, -mouth.f_104202_ / 16.0f).add((Vector3fc)relativePosition));
        Vector3f lookLocation = stack.m_85850_().m_252922_().transformPosition(new Vector3f(0.0f, 0.0f, -mouth.f_104202_ / 16.0f).add((Vector3fc)relativePosition).add((Vector3fc)relativeDirection));
        Vec3 positionOrigin = renderState.renderer().m_7860_(playerEntity, tickDelta).m_82520_((double)originLocation.x(), (double)originLocation.y(), (double)originLocation.z()).m_82520_(0.0, playerEntity.m_6047_() ? 0.125 : 0.0, 0.0);
        Vec3 positionLook = renderState.renderer().m_7860_(playerEntity, tickDelta).m_82520_((double)lookLocation.x(), (double)lookLocation.y(), (double)lookLocation.z()).m_82520_(0.0, playerEntity.m_6047_() ? 0.125 : 0.0, 0.0);
        Vec3 headDirection = positionOrigin.m_82546_(positionLook).m_82541_();
        float yaw = (float)Math.atan2(headDirection.f_82481_, headDirection.f_82479_);
        float pitch = (float)Math.atan2(headDirection.f_82480_, Math.sqrt(Math.pow(headDirection.f_82479_, 2.0) + Math.pow(headDirection.f_82481_, 2.0)));
        return new PositionedDirection(positionOrigin.m_82549_(playerEntity.m_20182_()), headDirection, yaw, pitch);
    }

    private record PositionedDirection(Vec3 position, Vec3 looking, float yaw, float pitch) {
    }
}

