/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client.mixin;

import com.boyonk.repoheads.client.EyeTargetManager;
import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.dummy.RepoClientPlayer;
import com.boyonk.repoheads.client.dummy.RepoPlayerListEntry;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerEntityMixin
extends Player
implements RepoClientPlayer {
    @Shadow
    @Final
    public ClientLevel f_108545_;
    @Shadow
    @Nullable
    private PlayerInfo f_108546_;
    @Unique
    private double repoHeads$audioLevel;
    @Unique
    private float repoHeads$prevMouthAngle;
    @Unique
    private float repoHeads$mouthAngle;
    @Unique
    private float repoHeads$smoothedMouthAngle;
    @Unique
    private final EyeTargetManager repoHeads$eyeTargetManager = new EyeTargetManager((AbstractClientPlayer)this);

    public AbstractClientPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public RepoData getRepoData() {
        if (this.f_108546_ == null) {
            return RepoData.DEFAULT;
        }
        return ((RepoPlayerListEntry)this.f_108546_).getRepoData();
    }

    @Override
    public void updateAudioLevel(double audioLevel) {
        this.repoHeads$audioLevel = Math.max(this.repoHeads$audioLevel, audioLevel);
    }

    @Override
    public float getMouthAngle(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.repoHeads$prevMouthAngle, (float)this.repoHeads$mouthAngle);
    }

    @Override
    public EyeTargetManager getEyeTargetManager() {
        return this.repoHeads$eyeTargetManager;
    }

    @Override
    public void repoUpdate() {
        this.getEyeTargetManager().tick();
        this.repoHeads$prevMouthAngle = this.repoHeads$mouthAngle;
        this.repoHeads$mouthAngle = (float)Math.min(0.0, Math.toRadians(-this.repoHeads$audioLevel - 45.0));
        if (this.repoHeads$mouthAngle < 0.0f) {
            EyeTargetManager.addPlayerTalking(this.f_108545_, (AbstractClientPlayer)this);
        }
        this.repoHeads$audioLevel = -180.0;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void repoHeads$tick(CallbackInfo ci) {
        this.repoUpdate();
    }
}

