/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.RepoHeadsClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.FileUtil;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class RepoHeadsClientConfig {
    public static final Codec<RepoHeadsClientConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RepoData.CODEC.fieldOf("data").forGetter(config -> config.data), (App)ButtonPos.CODEC.fieldOf("button_position").forGetter(config -> config.buttonPos), (App)Codec.BOOL.fieldOf("hide_self").forGetter(config -> config.hideSelf), (App)Codec.BOOL.fieldOf("hide_others").forGetter(config -> config.hideOthers)).apply((Applicative)instance, RepoHeadsClientConfig::new));
    private static final Logger LOGGER = RepoHeadsClient.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private RepoData data = RepoData.DEFAULT;
    private ButtonPos buttonPos = new ButtonPos(-70, -26);
    private boolean hideSelf = false;
    private boolean hideOthers = false;

    public RepoHeadsClientConfig(RepoData data, ButtonPos buttonPos, boolean hideSelf, boolean hideOthers) {
        this.data = data;
        this.buttonPos = buttonPos;
        this.hideSelf = hideSelf;
        this.hideOthers = hideOthers;
    }

    public RepoHeadsClientConfig() {
    }

    public static RepoHeadsClientConfig load() {
        block9: {
            Path path = RepoHeadsClientConfig.resolvePath();
            if (Files.isRegularFile(path, new LinkOption[0])) {
                RepoHeadsClientConfig repoHeadsClientConfig;
                JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8));
                try {
                    JsonElement json = Streams.parse((JsonReader)reader);
                    repoHeadsClientConfig = (RepoHeadsClientConfig)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, JsonParseException::new);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (JsonParseException exception) {
                        LOGGER.error("Couldn't parse config {}", (Object)path.getFileName(), (Object)exception);
                        break block9;
                    }
                    catch (IOException exception) {
                        LOGGER.error("Couldn't access config {}", (Object)path.getFileName(), (Object)exception);
                    }
                }
                reader.close();
                return repoHeadsClientConfig;
            }
        }
        RepoHeadsClientConfig config = new RepoHeadsClientConfig();
        RepoHeadsClientConfig.save(config);
        return config;
    }

    private static Path resolvePath() {
        return FMLPaths.CONFIGDIR.get().resolve("repo-heads.client.json");
    }

    public static void save(RepoHeadsClientConfig config) {
        Path path = RepoHeadsClientConfig.resolvePath();
        try {
            FileUtil.m_257659_((Path)path.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(false, IOException::new), (Appendable)writer);
            }
        }
        catch (IOException exception) {
            LOGGER.error("Failed to save config {}", (Object)path, (Object)exception);
        }
    }

    public void flush() {
        RepoHeadsClientConfig.save(this);
    }

    public RepoData data() {
        return this.data;
    }

    public RepoHeadsClientConfig data(RepoData data) {
        this.data = data;
        return this;
    }

    public ButtonPos buttonPos() {
        return this.buttonPos;
    }

    public RepoHeadsClientConfig buttonPos(ButtonPos buttonPos) {
        this.buttonPos = buttonPos;
        return this;
    }

    public boolean hideSelf() {
        return this.hideSelf;
    }

    public RepoHeadsClientConfig hideSelf(boolean hideSelf) {
        this.hideSelf = hideSelf;
        return this;
    }

    public boolean hideOthers() {
        return this.hideOthers;
    }

    public RepoHeadsClientConfig hideOthers(boolean hideOthers) {
        this.hideOthers = hideOthers;
        return this;
    }

    public record ButtonPos(int x, int y) {
        private static final Codec<ButtonPos> CODEC = Codec.INT.listOf().xmap(list -> new ButtonPos((Integer)list.get(0), (Integer)list.get(1)), buttonPos -> List.of(Integer.valueOf(buttonPos.x()), Integer.valueOf(buttonPos.y())));

        public int getX(int guiLeft, int xSize) {
            if (this.x > 0) {
                return guiLeft + this.x;
            }
            return guiLeft + xSize + this.x;
        }

        public int getY(int guiTop, int ySize) {
            if (this.y > 0) {
                return guiTop + this.y;
            }
            return guiTop + ySize + this.y;
        }
    }
}

