/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;

public class RepoDrawContextHelper {
    public static void drawColoredNineSlicedTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int outerSliceSize, int centerSliceWidth, int centerSliceHeight, int u, int v, int textureWidth, int textureHeight, int regionWidth, int regionHeight, int color) {
        RepoDrawContextHelper.drawColoredNineSlicedTexture(context, texture, x, y, width, height, outerSliceSize, outerSliceSize, outerSliceSize, outerSliceSize, centerSliceWidth, centerSliceHeight, u, v, textureWidth, textureHeight, regionWidth, regionHeight, color);
    }

    public static void drawColoredNineSlicedTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int outerSliceWidth, int outerSliceHeight, int centerSliceWidth, int centerSliceHeight, int u, int v, int textureWidth, int textureHeight, int regionWidth, int regionHeight, int color) {
        RepoDrawContextHelper.drawColoredNineSlicedTexture(context, texture, x, y, width, height, outerSliceWidth, outerSliceHeight, outerSliceWidth, outerSliceHeight, centerSliceWidth, centerSliceHeight, u, v, textureWidth, textureHeight, regionWidth, regionHeight, color);
    }

    public static void drawColoredNineSlicedTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int centerSliceWidth, int centerSliceHeight, int u, int v, int textureWidth, int textureHeight, int regionWidth, int regionHeight, int color) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        if (width == centerSliceWidth && height == centerSliceHeight) {
            RepoDrawContextHelper.drawColoredTexture(context, texture, x, y, u, v, width, height, textureWidth, textureHeight, regionWidth, regionHeight, color);
        } else if (height == centerSliceHeight) {
            RepoDrawContextHelper.drawColoredTexture(context, texture, x, y, u, v, leftSliceWidth, height, textureWidth, textureHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, u + leftSliceWidth, v, textureWidth, textureHeight, centerSliceWidth - rightSliceWidth - leftSliceWidth, centerSliceHeight, color);
            RepoDrawContextHelper.drawColoredTexture(context, texture, x + width - rightSliceWidth, y, u + centerSliceWidth - rightSliceWidth, v, rightSliceWidth, height, textureWidth, textureHeight, color);
        } else if (width == centerSliceWidth) {
            RepoDrawContextHelper.drawColoredTexture(context, texture, x, y, u, v, width, topSliceHeight, textureWidth, textureHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, u, v + topSliceHeight, textureWidth, textureHeight, centerSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight, color);
            RepoDrawContextHelper.drawColoredTexture(context, texture, x, y + height - bottomSliceHeight, u, v + centerSliceHeight - bottomSliceHeight, width, bottomSliceHeight, textureWidth, textureHeight, color);
        } else {
            RepoDrawContextHelper.drawColoredTexture(context, texture, x, y, u, v, leftSliceWidth, topSliceHeight, textureWidth, textureHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, u + leftSliceWidth, v, textureWidth, textureHeight, centerSliceWidth - rightSliceWidth - leftSliceWidth, topSliceHeight, color);
            RepoDrawContextHelper.drawColoredTexture(context, texture, x + width - rightSliceWidth, y, u + centerSliceWidth - rightSliceWidth, v, rightSliceWidth, topSliceHeight, textureWidth, textureHeight, color);
            RepoDrawContextHelper.drawColoredTexture(context, texture, x, y + height - bottomSliceHeight, u, v + centerSliceHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight, textureWidth, textureHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, u + leftSliceWidth, v + centerSliceHeight - bottomSliceHeight, textureWidth, textureHeight, centerSliceWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight, color);
            RepoDrawContextHelper.drawColoredTexture(context, texture, x + width - rightSliceWidth, y + height - bottomSliceHeight, u + centerSliceWidth - rightSliceWidth, v + centerSliceHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight, textureWidth, textureHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, u, v + topSliceHeight, textureWidth, textureHeight, leftSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, u + leftSliceWidth, v + topSliceHeight, textureWidth, textureHeight, centerSliceWidth - rightSliceWidth - leftSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight, color);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, u + centerSliceWidth - rightSliceWidth, v + topSliceHeight, textureWidth, textureHeight, rightSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight, color);
        }
    }

    public static void drawColoredRepeatingTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight, int color) {
        RepoDrawContextHelper.drawColoredRepeatingTexture(context, texture, x, y, width, height, u, v, textureWidth, textureHeight, width, height, color);
    }

    public static void drawColoredRepeatingTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight, int regionWidth, int regionHeight, int color) {
        int yOffset = 0;
        int remainingHeight = height;
        while (remainingHeight > 0) {
            int subRegionHeight = Math.min(remainingHeight, regionHeight);
            int xOffset = 0;
            int remainingWidth = width;
            while (remainingWidth > 0) {
                int subRegionWidth = Math.min(remainingWidth, regionWidth);
                RepoDrawContextHelper.drawColoredTexture(context, texture, x + xOffset, y + yOffset, u, v, subRegionWidth, subRegionHeight, textureWidth, textureHeight, subRegionWidth, subRegionHeight, color);
                remainingWidth -= regionWidth;
                xOffset += regionWidth;
            }
            remainingHeight -= regionHeight;
            yOffset += regionHeight;
        }
    }

    public static void drawColoredTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int color) {
        RepoDrawContextHelper.drawColoredTexture(context, texture, x, y, u, v, width, height, textureWidth, textureHeight, width, height, color);
    }

    public static void drawColoredTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int regionWidth, int regionHeight, int color) {
        RepoDrawContextHelper.drawColoredTexturedQuad(context, texture, x, x + width, y, y + height, 0, ((float)u + 0.0f) / (float)textureWidth, (float)(u + regionWidth) / (float)textureWidth, ((float)v + 0.0f) / (float)textureHeight, (float)(v + regionHeight) / (float)textureHeight, color);
    }

    private static void drawColoredTexturedQuad(GuiGraphics context, ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, int color) {
        int red = FastColor.ARGB32.m_13665_((int)color);
        int green = FastColor.ARGB32.m_13667_((int)color);
        int blue = FastColor.ARGB32.m_13669_((int)color);
        int alpha = FastColor.ARGB32.m_13655_((int)color);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Matrix4f matrix4f = context.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y2, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y1, (float)z).m_6122_(red, green, blue, alpha).m_7421_(u2, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }
}

