/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.Box2i;
import com.mojang.serialization.Codec;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class RepoData {
    public static final Codec<RepoData> CODEC = Codec.LONG.xmap(RepoData::unpack, RepoData::pack);
    private static final Box2i LEFT_SCLERA_BOUNDS = Box2i.immutable(0, 0, 3, 7);
    private static final Box2i RIGHT_SCLERA_BOUNDS = Box2i.immutable(4, 0, 7, 7);
    public static final RepoData DEFAULT = new RepoData(1, null, null, null, null, true);
    public final int mouth;
    @Nullable
    public final Box2i.Immutable leftSclera;
    @Nullable
    public final Box2i.Immutable rightSclera;
    @Nullable
    public final Box2i.Immutable leftPupil;
    @Nullable
    public final Box2i.Immutable rightPupil;
    public final boolean centerPupil;
    public final float leftEyeOffsetX;
    public final float leftEyeOffsetY;
    public final float leftEyeCenterX;
    public final float leftEyeCenterY;
    public final float rightEyeOffsetX;
    public final float rightEyeOffsetY;
    public final float rightEyeCenterX;
    public final float rightEyeCenterY;

    public RepoData(int mouth, @Nullable Box2i leftSclera, @Nullable Box2i rightSclera, @Nullable Box2i leftPupil, @Nullable Box2i rightPupil, boolean centerPupil) {
        float scleraCenterY;
        float scleraCenterX;
        float pupilCenterY;
        float pupilCenterX;
        this.mouth = mouth;
        if (leftSclera == null || !RepoData.validateSclera(leftSclera, true)) {
            this.leftSclera = null;
            this.leftPupil = null;
        } else if (leftPupil == null || !RepoData.validatePupil(leftSclera, leftPupil)) {
            this.leftSclera = leftSclera.immutable();
            this.leftPupil = null;
        } else {
            this.leftSclera = leftSclera.immutable();
            this.leftPupil = leftPupil.immutable();
        }
        if (rightSclera == null || !RepoData.validateSclera(rightSclera, false)) {
            this.rightSclera = null;
            this.rightPupil = null;
        } else if (rightPupil == null || !RepoData.validatePupil(rightSclera, rightPupil)) {
            this.rightSclera = rightSclera.immutable();
            this.rightPupil = null;
        } else {
            this.rightSclera = rightSclera.immutable();
            this.rightPupil = rightPupil.immutable();
        }
        this.centerPupil = centerPupil;
        if (this.leftSclera != null && this.leftPupil != null) {
            pupilCenterX = (float)(this.leftPupil.minX() + this.leftPupil.maxX() + 1) / 2.0f;
            pupilCenterY = (float)(this.leftPupil.minY() + this.leftPupil.maxY() + 1) / 2.0f;
            if (this.centerPupil) {
                scleraCenterX = (float)(this.leftSclera.minX() + this.leftSclera.maxX() + 1) / 2.0f;
                scleraCenterY = (float)(this.leftSclera.minY() + this.leftSclera.maxY() + 1) / 2.0f;
                this.leftEyeOffsetX = scleraCenterX - pupilCenterX;
                this.leftEyeOffsetY = scleraCenterY - pupilCenterY;
                this.leftEyeCenterX = scleraCenterX;
                this.leftEyeCenterY = scleraCenterY;
            } else {
                this.leftEyeOffsetX = 0.0f;
                this.leftEyeOffsetY = 0.0f;
                this.leftEyeCenterX = pupilCenterX;
                this.leftEyeCenterY = pupilCenterY;
            }
        } else {
            this.leftEyeOffsetX = 0.0f;
            this.leftEyeOffsetY = 0.0f;
            this.leftEyeCenterX = -1.0f;
            this.leftEyeCenterY = -1.0f;
        }
        if (this.rightSclera != null && this.rightPupil != null) {
            pupilCenterX = (float)(this.rightPupil.minX() + this.rightPupil.maxX() + 1) / 2.0f;
            pupilCenterY = (float)(this.rightPupil.minY() + this.rightPupil.maxY() + 1) / 2.0f;
            if (this.centerPupil) {
                scleraCenterX = (float)(this.rightSclera.minX() + this.rightSclera.maxX() + 1) / 2.0f;
                scleraCenterY = (float)(this.rightSclera.minY() + this.rightSclera.maxY() + 1) / 2.0f;
                this.rightEyeOffsetX = scleraCenterX - pupilCenterX;
                this.rightEyeOffsetY = scleraCenterY - pupilCenterY;
                this.rightEyeCenterX = scleraCenterX;
                this.rightEyeCenterY = scleraCenterY;
            } else {
                this.rightEyeOffsetX = 0.0f;
                this.rightEyeOffsetY = 0.0f;
                this.rightEyeCenterX = pupilCenterX;
                this.rightEyeCenterY = pupilCenterY;
            }
        } else {
            this.rightEyeOffsetX = 0.0f;
            this.rightEyeOffsetY = 0.0f;
            this.rightEyeCenterX = -1.0f;
            this.rightEyeCenterY = -1.0f;
        }
    }

    public static long pack(RepoData data) {
        long packed = 0L;
        packed |= (long)(data.mouth & 7);
        if (data.leftSclera != null) {
            packed |= (long)(data.leftSclera.minX() & 7) << 3;
            packed |= (long)(data.leftSclera.minY() & 7) << 6;
            packed |= (long)(data.leftSclera.maxX() & 7) << 9;
            packed |= (long)(data.leftSclera.maxY() & 7) << 12;
        } else {
            packed |= 0x38L;
            packed |= 0x1C0L;
            packed |= 0xE00L;
            packed |= 0x7000L;
        }
        if (data.rightSclera != null) {
            packed |= (long)(data.rightSclera.minX() & 7) << 15;
            packed |= (long)(data.rightSclera.minY() & 7) << 18;
            packed |= (long)(data.rightSclera.maxX() & 7) << 21;
            packed |= (long)(data.rightSclera.maxY() & 7) << 24;
        } else {
            packed |= 0L;
            packed |= 0L;
            packed |= 0L;
            packed |= 0L;
        }
        if (data.leftPupil != null) {
            packed |= (long)(data.leftPupil.minX() & 7) << 27;
            packed |= (long)(data.leftPupil.minY() & 7) << 30;
            packed |= (long)(data.leftPupil.maxX() & 7) << 33;
            packed |= (long)(data.leftPupil.maxY() & 7) << 36;
        } else {
            packed |= 0x38000000L;
            packed |= 0x1C0000000L;
            packed |= 0xE00000000L;
            packed |= 0x7000000000L;
        }
        if (data.rightPupil != null) {
            packed |= (long)(data.rightPupil.minX() & 7) << 39;
            packed |= (long)(data.rightPupil.minY() & 7) << 42;
            packed |= (long)(data.rightPupil.maxX() & 7) << 45;
            packed |= (long)(data.rightPupil.maxY() & 7) << 48;
        } else {
            packed |= 0L;
            packed |= 0L;
            packed |= 0L;
            packed |= 0L;
        }
        packed |= (data.centerPupil ? 1L : 0L) << 51;
        return packed |= Long.MIN_VALUE;
    }

    public static RepoData unpack(long packed) {
        int mouth = (int)(packed & 7L);
        Box2i.Immutable leftEyeSclera = Box2i.immutable((int)(packed >> 3 & 7L), (int)(packed >> 6 & 7L), (int)(packed >> 9 & 7L), (int)(packed >> 12 & 7L));
        Box2i.Immutable rightEyeSclera = Box2i.immutable((int)(packed >> 15 & 7L), (int)(packed >> 18 & 7L), (int)(packed >> 21 & 7L), (int)(packed >> 24 & 7L));
        Box2i.Immutable leftEyePupil = Box2i.immutable((int)(packed >> 27 & 7L), (int)(packed >> 30 & 7L), (int)(packed >> 33 & 7L), (int)(packed >> 36 & 7L));
        Box2i.Immutable rightEyePupil = Box2i.immutable((int)(packed >> 39 & 7L), (int)(packed >> 42 & 7L), (int)(packed >> 45 & 7L), (int)(packed >> 48 & 7L));
        boolean centerPupil = (packed >> 51 & 1L) != 0L;
        return new RepoData(mouth, leftEyeSclera, rightEyeSclera, leftEyePupil, rightEyePupil, centerPupil);
    }

    public static boolean validateSclera(Box2i sclera, boolean left) {
        return (left ? LEFT_SCLERA_BOUNDS : RIGHT_SCLERA_BOUNDS).contains(sclera);
    }

    public static boolean validatePupil(Box2i sclera, Box2i pupil) {
        return sclera.contains(pupil);
    }

    public RepoData withMouth(int mouth) {
        return new RepoData(mouth, this.leftSclera, this.rightSclera, this.leftPupil, this.rightPupil, this.centerPupil);
    }

    public RepoData withLeftSclera(Box2i sclera) {
        return new RepoData(this.mouth, sclera, this.rightSclera, this.leftPupil, this.rightPupil, this.centerPupil);
    }

    public RepoData withRightSclera(Box2i sclera) {
        return new RepoData(this.mouth, this.leftSclera, sclera, this.leftPupil, this.rightPupil, this.centerPupil);
    }

    public RepoData withLeftPupil(Box2i pupil) {
        return new RepoData(this.mouth, this.leftSclera, this.rightSclera, pupil, this.rightPupil, this.centerPupil);
    }

    public RepoData withRightPupil(Box2i pupil) {
        return new RepoData(this.mouth, this.leftSclera, this.rightSclera, this.leftPupil, pupil, this.centerPupil);
    }

    public RepoData withCenterPupil(boolean centerPupil) {
        return new RepoData(this.mouth, this.leftSclera, this.rightSclera, this.leftPupil, this.rightPupil, centerPupil);
    }

    public static boolean isValid(long packed) {
        return packed < 0L;
    }

    public String toString() {
        return "RepoData{mouth=" + this.mouth + ", leftSclera=" + this.leftSclera + ", rightSclera=" + this.rightSclera + ", leftPupil=" + this.leftPupil + ", rightPupil=" + this.rightPupil + ", leftEyeCenterX=" + this.leftEyeCenterX + ", leftEyeCenterY=" + this.leftEyeCenterY + ", rightEyeCenterX=" + this.rightEyeCenterX + ", rightEyeCenterY=" + this.rightEyeCenterY + ", leftEyeOffsetX=" + this.leftEyeOffsetX + ", leftEyeOffsetY=" + this.leftEyeOffsetY + ", rightEyeOffsetX=" + this.rightEyeOffsetX + ", rightEyeOffsetY=" + this.rightEyeOffsetY + ", centerPupil=" + this.centerPupil + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepoData repoData = (RepoData)o;
        return RepoData.pack(repoData) == RepoData.pack(this);
    }

    public int hashCode() {
        return Objects.hash(this.mouth, this.leftSclera, this.rightSclera, this.leftPupil, this.rightPupil, this.centerPupil, Float.valueOf(this.leftEyeOffsetX), Float.valueOf(this.leftEyeOffsetY), Float.valueOf(this.leftEyeCenterX), Float.valueOf(this.leftEyeCenterY), Float.valueOf(this.rightEyeOffsetX), Float.valueOf(this.rightEyeOffsetY), Float.valueOf(this.rightEyeCenterX), Float.valueOf(this.rightEyeCenterY));
    }
}

