/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.dummy.RepoClientPlayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class EyeTargetManager {
    private static final Vector2f TEMP_VECTOR = new Vector2f();
    private static final RandomSource TEMP_RANDOM = RandomSource.m_216327_();
    private final Vector2f prevLeftEye = new Vector2f();
    private final Vector2f prevRightEye = new Vector2f();
    private final Vector2f leftEye = new Vector2f();
    private final Vector2f rightEye = new Vector2f();
    private Vec3 prevTarget = Vec3.f_82478_;
    @Nullable
    private Vec3 target = Vec3.f_82478_;
    private final EyeCatcher defaultEyeCatcher;
    private final List<EyeCatcher> eyeCatchers = new ArrayList<EyeCatcher>();

    public EyeTargetManager(AbstractClientPlayer player) {
        this.defaultEyeCatcher = new EyeCatcher(() -> null, 0, 0);
    }

    public void tick() {
        this.prevLeftEye.set((Vector2fc)this.leftEye);
        this.leftEye.set(Float.NaN, Float.NaN);
        this.prevRightEye.set((Vector2fc)this.rightEye);
        this.rightEye.set(Float.NaN, Float.NaN);
        this.prevTarget = this.target;
        this.target = this.calcEyeTarget();
    }

    @Nullable
    private Vec3 calcEyeTarget() {
        Iterator<EyeCatcher> iterator = this.eyeCatchers.iterator();
        EyeCatcher current = this.defaultEyeCatcher;
        while (iterator.hasNext()) {
            EyeCatcher eyeCatcher = iterator.next();
            if (eyeCatcher.tickDuration()) {
                iterator.remove();
                continue;
            }
            if (eyeCatcher.priority() > current.priority()) {
                current = eyeCatcher;
                continue;
            }
            if (eyeCatcher.priority() != current.priority() || eyeCatcher.duration() <= current.duration()) continue;
            current = eyeCatcher;
        }
        return current.pos();
    }

    private void add(Supplier<Vec3> posSupplier, int duration, int priority) {
        this.eyeCatchers.add(new EyeCatcher(posSupplier, duration, priority));
    }

    public static void addToAllInRadius(ClientLevel world, double radius, Supplier<Vec3> posSupplier, int duration, int priority) {
        EyeTargetManager.addToAllInRadius(null, world, radius, posSupplier, duration, priority);
    }

    public static void addToAllInRadius(@Nullable Predicate<AbstractClientPlayer> predicate, ClientLevel world, double radius, Supplier<Vec3> posSupplier, int duration, int priority) {
        double radiusSquared = radius * radius;
        Vec3 pos = posSupplier.get();
        for (AbstractClientPlayer player : world.m_6907_()) {
            if (predicate != null && !predicate.test(player) || !(player.m_20238_(pos) < radiusSquared)) continue;
            ((RepoClientPlayer)player).getEyeTargetManager().add(posSupplier, duration, priority);
        }
    }

    public static void addPlayerTalking(ClientLevel world, AbstractClientPlayer player) {
        int duration = 0;
        long time = world.m_46467_() / 5L;
        for (int offset = -2; offset <= 2; ++offset) {
            TEMP_RANDOM.m_188584_(time + (long)offset);
            duration += TEMP_RANDOM.m_216332_(1, 60);
        }
        EyeTargetManager.addToAllInRadius(p -> p != player && p.m_5833_() == player.m_5833_(), world, 8.0, () -> ((AbstractClientPlayer)player).m_146892_(), duration /= 5, 2);
    }

    public static void addWorldEvent(ClientLevel world, int eventId, BlockPos pos, int data) {
        Vec3 vec3d = Vec3.m_82512_((Vec3i)pos);
        EyeTargetManager.addToAllInRadius(world, 10.0, () -> vec3d, 20, 1);
    }

    public static void addSound(ClientLevel world, double x, double y, double z, SoundEvent event, SoundSource category, float volume, float pitch, boolean useDistance) {
        if (event.m_11660_().m_135815_().endsWith(".step")) {
            return;
        }
        Vec3 vec3d = new Vec3(x, y, z);
        EyeTargetManager.addToAllInRadius(p -> p.m_20275_(x, y, z) > 0.025, world, 8.0, () -> vec3d, 20, 0);
    }

    @Nullable
    public Vec3 getTarget(float tickDelta) {
        if (this.target == null) {
            return this.prevTarget;
        }
        if (this.prevTarget == null) {
            return this.target;
        }
        return new Vec3(Mth.m_14139_((double)tickDelta, (double)this.prevTarget.f_82479_, (double)this.target.f_82479_), Mth.m_14139_((double)tickDelta, (double)this.prevTarget.f_82480_, (double)this.target.f_82480_), Mth.m_14139_((double)tickDelta, (double)this.prevTarget.f_82481_, (double)this.target.f_82481_));
    }

    public Vector2f updateLeftEyeFromRendering(float x, float y, float tickDelta) {
        return this.updateEyeFromRendering(x, y, tickDelta, this.leftEye, this.prevLeftEye);
    }

    public Vector2f updateRightEyeFromRendering(float x, float y, float tickDelta) {
        return this.updateEyeFromRendering(x, y, tickDelta, this.rightEye, this.prevRightEye);
    }

    private Vector2f updateEyeFromRendering(float x, float y, float tickDelta, Vector2f current, Vector2f previous) {
        if (Float.isNaN(current.x) || Float.isNaN(current.y)) {
            current.set(x, y);
        }
        x = Mth.m_14179_((float)tickDelta, (float)previous.x, (float)current.x);
        y = Mth.m_14179_((float)tickDelta, (float)previous.y, (float)current.y);
        return TEMP_VECTOR.set(x, y);
    }

    private static class EyeCatcher {
        private final Supplier<Vec3> posSupplier;
        private int duration;
        private final int priority;

        EyeCatcher(Supplier<Vec3> posSupplier, int duration, int priority) {
            this.posSupplier = posSupplier;
            this.duration = duration;
            this.priority = priority;
        }

        public boolean tickDuration() {
            --this.duration;
            return this.duration < 0;
        }

        public int duration() {
            return this.duration;
        }

        public int priority() {
            return this.priority;
        }

        public Vec3 pos() {
            return this.posSupplier.get();
        }
    }

    @FunctionalInterface
    public static interface EyeRenderUpdater {
        public Vector2fc update(float var1, float var2);
    }
}

